function out = robustmean(data,dim) ;
% function out = robustmean(data,dim) ;
%
% Robust mean of the columns of data.  The mean is robust in the sense that
%  missing data (NaNs) are completely disregarded when computing the mean.
% dim denotes the dimension along which the mean is to be taken (default is 1).
%
% Written by Eric Swanson, 8/06.

if (nargin<2); dim=1; end ;

% Find and remove NaN's from the data:
good = ~isnan(data) ;
data(~good) = 0 ;

out = sum(good.*data,dim) ./ sum(good,dim) ;
